<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/response_helper.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->name) &&
    !empty($data->email) &&
    !empty($data->password) &&
    !empty($data->role)
) {
    // Check if email already exists
    $query = "SELECT id FROM users WHERE email = :email";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':email', $data->email);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        error('Email already exists');
    }
    
    $query = "INSERT INTO users SET name=:name, email=:email, password=:password, role=:role";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->name = htmlspecialchars(strip_tags($data->name));
    $data->email = htmlspecialchars(strip_tags($data->email));
    $data->role = htmlspecialchars(strip_tags($data->role));
    
    // Hash password
    $password_hash = password_hash($data->password, PASSWORD_DEFAULT);
    
    $stmt->bindParam(':name', $data->name);
    $stmt->bindParam(':email', $data->email);
    $stmt->bindParam(':password', $password_hash);
    $stmt->bindParam(':role', $data->role);
    
    if ($stmt->execute()) {
        $user_id = $db->lastInsertId();
        
        response([
            'message' => 'User created successfully',
            'user' => [
                'id' => $user_id,
                'name' => $data->name,
                'email' => $data->email,
                'role' => $data->role
            ]
        ], 201);
    } else {
        error('Unable to create user');
    }
} else {
    error('Incomplete data');
}
?>