<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->kode) &&
    !empty($data->nama) &&
    !empty($data->jumlah) &&
    !empty($data->siswa)
) {
    $query = "INSERT INTO payment SET kode=:kode, nama=:nama, jumlah=:jumlah, is_paid=:is_paid, paid_at=:paid_at, siswa=:siswa";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->kode = htmlspecialchars(strip_tags($data->kode));
    $data->nama = htmlspecialchars(strip_tags($data->nama));
    $data->jumlah = htmlspecialchars(strip_tags($data->jumlah));
    $data->siswa = htmlspecialchars(strip_tags($data->siswa));
    
    $is_paid = $data->is_paid ?? false;
    $paid_at = $is_paid ? date('Y-m-d H:i:s') : null;
    
    $stmt->bindParam(':kode', $data->kode);
    $stmt->bindParam(':nama', $data->nama);
    $stmt->bindParam(':jumlah', $data->jumlah);
    $stmt->bindParam(':is_paid', $is_paid);
    $stmt->bindParam(':paid_at', $paid_at);
    $stmt->bindParam(':siswa', $data->siswa);
    
    if ($stmt->execute()) {
        $payment_id = $db->lastInsertId();
        
        response([
            'message' => 'Payment created successfully',
            'id' => $payment_id
        ], 201);
    } else {
        error('Unable to create payment');
    }
} else {
    error('Incomplete data');
}
?>