<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$query = "SELECT * FROM pengumuman ORDER BY created_at DESC";
$stmt = $db->prepare($query);
$stmt->execute();

$num = $stmt->rowCount();

if ($num > 0) {
    $pengumuman_arr = array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        extract($row);
        
        $pengumuman_item = array(
            'id' => $id,
            'judul' => $judul,
            'isi' => $isi,
            'kategori' => $kategori,
            'created_at' => $created_at
        );
        
        array_push($pengumuman_arr, $pengumuman_item);
    }
    
    response($pengumuman_arr);
} else {
    response(['message' => 'No pengumuman found']);
}
?>