<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: PUT');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

// Get ID from URL
$id = isset($_GET['id']) ? $_GET['id'] : die();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->siswa) &&
    !empty($data->mata_pelajaran) &&
    !empty($data->nilai) &&
    !empty($data->keterangan)
) {
    $query = "UPDATE rapor SET siswa=:siswa, mata_pelajaran=:mata_pelajaran, nilai=:nilai, keterangan=:keterangan, is_locked=:is_locked WHERE id=:id";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->siswa = htmlspecialchars(strip_tags($data->siswa));
    $data->mata_pelajaran = htmlspecialchars(strip_tags($data->mata_pelajaran));
    $data->nilai = htmlspecialchars(strip_tags($data->nilai));
    $data->keterangan = htmlspecialchars(strip_tags($data->keterangan));
    
    $is_locked = $data->is_locked ?? false;
    
    $stmt->bindParam(':id', $id);
    $stmt->bindParam(':siswa', $data->siswa);
    $stmt->bindParam(':mata_pelajaran', $data->mata_pelajaran);
    $stmt->bindParam(':nilai', $data->nilai);
    $stmt->bindParam(':keterangan', $data->keterangan);
    $stmt->bindParam(':is_locked', $is_locked);
    
    if ($stmt->execute()) {
        response([
            'message' => 'Rapor updated successfully'
        ]);
    } else {
        error('Unable to update rapor');
    }
} else {
    error('Incomplete data');
}
?>