<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->judul) &&
    !empty($data->mata_pelajaran) &&
    !empty($data->guru) &&
    !empty($data->deadline)
) {
    $query = "INSERT INTO tugas SET judul=:judul, deskripsi=:deskripsi, mata_pelajaran=:mata_pelajaran, guru=:guru, attachments=:attachments, deadline=:deadline";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->judul = htmlspecialchars(strip_tags($data->judul));
    $data->deskripsi = htmlspecialchars(strip_tags($data->deskripsi));
    $data->mata_pelajaran = htmlspecialchars(strip_tags($data->mata_pelajaran));
    $data->guru = htmlspecialchars(strip_tags($data->guru));
    
    $attachments_json = json_encode($data->attachments ?? []);
    
    $stmt->bindParam(':judul', $data->judul);
    $stmt->bindParam(':deskripsi', $data->deskripsi);
    $stmt->bindParam(':mata_pelajaran', $data->mata_pelajaran);
    $stmt->bindParam(':guru', $data->guru);
    $stmt->bindParam(':attachments', $attachments_json);
    $stmt->bindParam(':deadline', $data->deadline);
    
    if ($stmt->execute()) {
        $tugas_id = $db->lastInsertId();
        
        response([
            'message' => 'Tugas created successfully',
            'id' => $tugas_id
        ], 201);
    } else {
        error('Unable to create tugas');
    }
} else {
    error('Incomplete data');
}
?>