<?php
class JWT {
    // Secret key for encoding and decoding
    private static $secret_key = 'ntlapi123*/123#';
    private static $encrypt = ['HS256'];
    
    // Create JWT token
    public static function encode($payload) {
        $header = json_encode(['typ' => 'JWT', 'alg' => 'HS256']);
        
        $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
        $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode(json_encode($payload)));
        
        $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, self::$secret_key, true);
        $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
        
        return $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
    }
    
    // Decode JWT token
    public static function decode($jwt) {
        $tokenParts = explode('.', $jwt);
        
        if (count($tokenParts) != 3) {
            return false;
        }
        
        $header = base64_decode(str_replace(['-', '_'], ['+', '/'], $tokenParts[0]));
        $payload = base64_decode(str_replace(['-', '_'], ['+', '/'], $tokenParts[1]));
        $signature = base64_decode(str_replace(['-', '_'], ['+', '/'], $tokenParts[2]));
        
        // Verify signature
        $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
        $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
        
        $expectedSignature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, self::$secret_key, true);
        $base64UrlExpectedSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($expectedSignature));
        
        if (!hash_equals($base64UrlExpectedSignature, $tokenParts[2])) {
            return false;
        }
        
        // Check expiration
        $payloadObj = json_decode($payload);
        if (isset($payloadObj->exp) && $payloadObj->exp < time()) {
            return false;
        }
        
        return $payloadObj;
    }
    
    // Middleware to check if token is valid
    public static function authenticate() {
        $headers = getallheaders();
        
        if (!isset($headers['Authorization'])) {
            http_response_code(401);
            echo json_encode(['message' => 'Access denied']);
            exit();
        }
        
        $authHeader = $headers['Authorization'];
        $arr = explode(" ", $authHeader);
        
        if (count($arr) != 2 || $arr[0] != 'Bearer') {
            http_response_code(401);
            echo json_encode(['message' => 'Invalid token format']);
            exit();
        }
        
        $jwt = $arr[1];
        $decoded = JWT::decode($jwt);
        
        if (!$decoded) {
            http_response_code(401);
            echo json_encode(['message' => 'Invalid token']);
            exit();
        }
        
        return $decoded;
    }
}
?>